-- ui screen events

offset = 0
timer = 0
startoffset = 0
flag1 = 0
fspeed = 50

function OnLoad ()
    CacheSound("sfx/whoosh1.ogg")
    
	SetProperty ("/StoryIntro:enter_trans_duration", 0.3);
	SetProperty ("/StoryIntro:leave_trans_duration", 2);
    
end;

function OnEnter ()
	InitGameLevel ();
	Reset()
	--SetProperty ("Continue:visible", 0);
end;

function Reset ()
   timer = 0
   offset = 0
   startoffset = 0
   flag1 = 0
   SetProperty ("story1:position_offset.y", -500)
   SetProperty ("label1t:angle", -0.11);
   
   SetProperty ("story2:position_offset.y", -500)
   SetProperty ("story2:alpha", 0.0)
   SetProperty ("label2t:position_offset.y", -500)
   SetProperty ("label2t:alpha", 0.0)
   SetProperty ("label2t:angle", 0.04);
   
   SetProperty ("story3:position_offset.y", -500)
   SetProperty ("story3:alpha", 0.0)
   SetProperty ("label3t:position_offset.y", -500)
   SetProperty ("label3t:alpha", 0.0)
   SetProperty ("label3t:angle", -0.11);
   
   SetProperty ("story4:position_offset.y", -500)
   SetProperty ("story4:alpha", 0.0)
   SetProperty ("story4:angle", 0.04)
   SetProperty ("story4:scale", 0.73)
   
   SetProperty ("label4t:position_offset.y", -500)
   SetProperty ("label4t:alpha", 0.0)
   SetProperty ("label4t:angle", 0.04)
end;

function OnLeave ()
		--InitGameLevel ();
		PushScreen ("Game");
end;


function OnClick (name)

	if (name == "Continue") then
		PopScreen ();--SwitchScreen ("WorldMap");
	end;
	
	if (name == "Reset") then
		Reset ()
	end;
end;


function OnUpdate (tdelta)

  alpha = 99.0
  timer = timer + tdelta;
  if (timer > 1) then
		SetProperty ("Continue:visible", 1);
  end;
  
  akey = GetActiveScreenAnimKey ();
  realoffset = -timer * 40   
  	
  if offset > -800 then
      offset = realoffset
  end;
  SetProperty ("bg:position_offset.x", offset);
  SetProperty ("story1:position_offset.x", offset);
  SetProperty ("story2:position_offset.x", offset);
  SetProperty ("story3:position_offset.x", offset);
  SetProperty ("story4:position_offset.x", offset);
  

  SetProperty ("label1t:position_offset.x", offset);

  SetProperty ("label2t:position_offset.x", offset);

  SetProperty ("label3t:position_offset.x", offset);

  SetProperty ("label4t:position_offset.x", offset);
  
  if offset*-1 > GetProperty("story1:position.x")-450 then
      SetProperty ("story1:position_offset.y", 0)
  end; 
  
  if (offset*-1 > GetProperty("story2:position.x")-450) then
      if(flag1 == 0) then
          startoffset = realoffset   
          PlaySound("sfx/whoosh1.ogg")
          SetProperty ("story2:position_offset.y", 0)
       
          SetProperty ("label2t:position_offset.y", 0)
          flag1 = 1
      end;               
  end; 
   
  if (flag1 == 1) then
      alpha = (math.abs(realoffset) - math.abs(startoffset)) / fspeed
      SetProperty ("story2:alpha", alpha)

      SetProperty ("label2t:alpha", alpha)
      if alpha > 1.0 and flag1 == 1 then
           flag1 = 2
      end
  end;
      
  if offset*-1 > GetProperty("story3:position.x")-450 then
      if(flag1 == 2) then
          startoffset = realoffset   
          PlaySound("sfx/whoosh1.ogg")
          SetProperty ("story3:position_offset.y", 0)

          SetProperty ("label3t:position_offset.y", 0)
          flag1 = 3
      end;              
  end; 
  
  if (flag1 == 3) then
      alpha = (math.abs(realoffset) - math.abs(startoffset)) / fspeed
      SetProperty ("story3:alpha", alpha)

      SetProperty ("label3t:alpha", alpha)
      if alpha > 1.0 and flag1 == 3 then
           flag1 = 4
      end
  end;
  
  if offset*-1 > GetProperty("story4:position.x")-450-200 then
      if(flag1 == 4) then
          startoffset = realoffset   
          PlaySound("sfx/whoosh1.ogg")
          SetProperty ("story4:position_offset.y", 0)
 
          SetProperty ("label4t:position_offset.y", 0)
          flag1 = 5
      end;              
  end; 
  
  if (flag1 == 5) then
      alpha = (math.abs(realoffset) - math.abs(startoffset)) / fspeed
      SetProperty ("story4:alpha", alpha)

      SetProperty ("label4t:alpha", alpha)
      if alpha > 1.0 and flag1 == 5 then
           flag1 = 6
      end
  end; 
  
  --SetProperty ("Reset:button.text", string.format("alpha:%f offset:%d startoffset:%d", alpha, realoffset, startoffset))
  
end;


function OnDraw ()

	if (IsScreenLeaving ()) then
		SetProperty ("story4:visible", 0);
		x = GetProperty ("story4:static_position.x");
		y = GetProperty ("story4:static_position.y");
		
		start_scale = GetProperty ("story4:scale");
		end_scale = 1.75;

		start_angle = GetProperty ("story4:angle");
	
		trans = 1-GetActiveScreenTransPhase ();
		angle = (1-trans) * start_angle;-- + (1-trans) * 0.25;
		
		x = (1-trans) * x + trans * 400;
		y = (1-trans) * y + trans * 300;

		NX_SetAlpha (1);
		NX_SetColor (1,1,1);
		NX_DrawBitmapRS ("story/square-view1-big.png", x, y, angle, start_scale + (end_scale - start_scale) * trans);

		
		NX_SetAlpha (trans);
		NX_SetColor (1,1,1);
		NX_DrawBitmapRS ("GAME_BACKGROUND", x, y, angle, 0.75 + 0.25 * trans);
		
	else
		SetProperty ("story4:visible", 1);
	end;
end;
